/*
*  DISCLAIMER:
*
*      THIS SOFTWARE, SOURCE CODE AND ASSOCIATED MATERIALS INCLUDING BUT NOT LIMITED TO TUTORIALS,
*      GUIDES AND COMMENTARY PROVIDED WITH THIS EXERCISE ARE ONLY DESIGNED FOR REFERENCE PURPOSES
*      TO GIVE AN EXAMPLE TO LICENSEE FOR THEIR OWN NECESSARY DEVELOPMENT OF THEIR OWN SOFTWARE AND/OR
*      APPLICATION. IT IS NOT DESIGNED FOR ANY SPECIAL PURPOSE, SERIAL PRODUCTION OR USE IN MEDICAL,
*      MILITARY, AIR CRAFT, AVIATION, SPACE OF LIFE SUPPORT EQUIPMENT.
*
*      TO THE EXTENT PERMITTED BY LAW, THE EXERCISE SOFTWARE AND/OR SOURCE CODE AND/OR AND ASSOCIATED
*      MATERIALS IS PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND AND ONLY FOR REFERENCE PURPOSES.
*
*      SYNAPTIC LABORATORIES LTD. MAKES NO WARRANTIES, EITHER EXPRESS OR IMPLIED, WITH RESPECT TO THE
*      LICENSED SOFTWARE AND/OR SOURCE CODE AND/OR ASSOCIATED MATERIALS, CONFIDENTIAL INFORMATION AND
*      DOCUMENTATION PROVIDED HEREUNDER.�
*
*      SYNAPTIC LABORATORIES LTD. SPECIFICALLY DISCLAIMS THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
*      FITNESS FOR A PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT OF ANY INTELLECTUAL
*      PROPERTY RIGHT OF ANY THIRD PARTY WITH REGARD TO THE SOFTWARE, DOCUMENTATION (SCHEMATICS ETC.),
*      SOURCE CODE AND ASSOCIATED MATERIALS, CONFIDENTIAL INFORMATION AND DOCUMENTATION.
*
*      ANY USE, COMPILATION AND TESTING OF THE SOFTWARE AND/OR SOURCE CODE IS AT LICENSEE`S OWN RISK
*      AND LICENSEE IS OBLIGED TO CONDUCT EXTENSIVE TESTS TO AVOID ANY ERRORS AND FAILURE IN THE
*      COMPILED SOURCE CODE, DOCUMENTATION (SCHEMATICS ETC.) AND THE HEREFROM GENERATED SOFTWARE
*      OF LICENSEE.
*
*      EXCEPT FOR WILFULL INTENT SYNAPTIC LABORATORIES LTD. SHALL IN NO EVENT BE ENTITLED TO OR LIABLE
*      FOR ANY INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES OF ANY KIND OR NATURE, INCLUDING,
*      WITHOUT LIMITATION, BUSINESS INTERRUPTION COSTS, LOSS OF PROFIT OR REVENUE, LOSS OF DATA,
*      PROMOTIONAL OR MANUFACTURING EXPENSES, OVERHEAD, COSTS OR EXPENSES ASSOCIATED WITH WARRANTY
*      OR INTELLECTUAL PROPERTY INFRINGEMENT CLAIMS, INJURY TO REPUTATION OR LOSS OF CUSTOMERS.
*
*/



#include "sll_ca_xspi_mc_init.h"


/******************************************************************
*  Function: xspi_mc_dev0_null_init
*
*  Purpose: Set Device 0 parameters for No memory
*
******************************************************************/
 void xspi_mc_dev0_null_init(uint32_t base_csr)
{
/*  set dev 1 config  */
    IOWR_SLL_XSPI_MC_REG_DEV0_CFG(base_csr, 0x00000000);

/*  set dev 1 timing  */
    IOWR_SLL_XSPI_MC_REG_DEV0_TIM(base_csr, 0x00000000);

}

/******************************************************************
*  Function: xspi_mc_dev0_s26ks512s_init
*
*  Purpose: Set Device 1 parameters for s26ks512s memory
*
******************************************************************/
 void xspi_mc_dev0_s26ks_init(uint32_t base_csr, uint8_t size_log2 )
{
    uint32_t  sll_dev0_cfg =  sll_s26ks_data[0] | (size_log2    << XSPI_MC_REG_DEV_CFG_DEV_SIZE_IDX);
   
/*  set dev 1 config  */
    IOWR_SLL_XSPI_MC_REG_DEV0_CFG(base_csr,  sll_dev0_cfg);

/*  set dev 1 timing  */
    IOWR_SLL_XSPI_MC_REG_DEV0_TIM(base_csr,  sll_s26ks_data[1]);

/*  set dev 1 rw cmd  */
    IOWR_SLL_XSPI_MC_REG_DEV0_CMD1(base_csr, sll_s26ks_data[2]);
    IOWR_SLL_XSPI_MC_REG_DEV0_CMD0(base_csr, sll_s26ks_data[3]);

}


/******************************************************************
*  Function: xspi_mc_dev0_s26hs512s_init
*
*  Purpose: Set Device 1 parameters for s26hs512s memory
*
******************************************************************/
 void xspi_mc_dev0_s26hs_init(uint32_t base_csr,  uint8_t size_log2, uint8_t bootmode)
{
    uint32_t  sll_dev0_cfg =  sll_s26hs_data[0] | (size_log2    << XSPI_MC_REG_DEV_CFG_DEV_SIZE_IDX);

/*  set dev 1 config  */
    IOWR_SLL_XSPI_MC_REG_DEV0_CFG(base_csr,  sll_dev0_cfg);

/*  set dev 1 timing  */
    IOWR_SLL_XSPI_MC_REG_DEV0_TIM(base_csr,  sll_s26hs_data[1]);

/*  set dev 1 rw cmd  */
    IOWR_SLL_XSPI_MC_REG_DEV0_CMD1(base_csr, sll_s26hs_data[2]);
    IOWR_SLL_XSPI_MC_REG_DEV0_CMD0(base_csr, sll_s26hs_data[3]);

/*  switch from x1 to DDR if needed  */    
    if (bootmode == 1) {
    IOWR_SLL_XSPI_MC_REG_SPI_DDR0(base_csr, sll_s26hs_data[5]);
    IOWR_SLL_XSPI_MC_REG_SPI_DDR1(base_csr, sll_s26hs_data[4]);  	
    }


}


/******************************************************************
*  Function: xspi_mc_dev0_s28hs512s_init
*
*  Purpose: Set Device 1 parameters for s28hs512s memory
*
******************************************************************/
 void xspi_mc_dev0_s28hs_init(uint32_t base_csr,  uint8_t size_log2,  uint8_t bootmode)
{
    uint32_t  sll_dev0_cfg =  sll_s28hs_data[0] | (size_log2    << XSPI_MC_REG_DEV_CFG_DEV_SIZE_IDX);

/*  set dev 1 config  */
    IOWR_SLL_XSPI_MC_REG_DEV0_CFG(base_csr, sll_dev0_cfg);

/*  set dev 1 timing  */
    IOWR_SLL_XSPI_MC_REG_DEV0_TIM(base_csr, sll_s28hs_data[1]);

/*  set dev 1 rw cmd  */
    IOWR_SLL_XSPI_MC_REG_DEV0_CMD1(base_csr, sll_s28hs_data[2]);
    IOWR_SLL_XSPI_MC_REG_DEV0_CMD0(base_csr, sll_s28hs_data[3]);

/*  switch from x1 to DDR if needed  */    
    if (bootmode == 1) {
    IOWR_SLL_XSPI_MC_REG_SPI_DDR0(base_csr, sll_s28hs_data[5]);
    IOWR_SLL_XSPI_MC_REG_SPI_DDR1(base_csr, sll_s28hs_data[4]);  	

    //wait 100 us
    SLL_DelayMicroseconds(100);

    }

/*  program xSPI  WREN  */
    sll_cs0_xspi_p1_format_1a_write(base_csr, 0x0606);

/*  program xSPI - program cas latency  */
    sll_cs0_xspi_p1_format_1d_write_x16(base_csr, 0x7171, 0x00800003, sll_s28hs_data[6]);

/*  program xSPI  WREN  */
    sll_cs0_xspi_p1_format_1a_write(base_csr, 0x0606);

/*program xSPI - program cas latency */
    sll_cs0_xspi_p1_format_1d_write_x16(base_csr, 0x7171, 0x00800004, sll_s28hs_data[7]);


}


/******************************************************************
*  Function: xspi_mc_dev0_xspi_type1_init
*
*  Purpose: Set Device 1 parameters for mt35xu/gd55lx memory
*
******************************************************************/
 void xspi_mc_dev0_xspi_type1_init(uint32_t base_csr,  uint8_t size_log2, uint8_t read_latency ,  uint8_t bootmode)
{
    uint32_t  sll_dev0_cfg        =  sll_xspi_type1_data[0] | (size_log2    << XSPI_MC_REG_DEV_CFG_DEV_SIZE_IDX);
    uint32_t  sll_dev0_tim        =  sll_xspi_type1_data[1] | (read_latency << XSPI_MC_REG_DEV_TIM_READ_TACC_IDX) ;
    uint32_t  sll_xspi_type1_cfg1 =  read_latency | (read_latency << 8);

/*  set dev 1 config  */
    IOWR_SLL_XSPI_MC_REG_DEV0_CFG(base_csr, sll_dev0_cfg);

/*  set dev 1 timing  */
    IOWR_SLL_XSPI_MC_REG_DEV0_TIM(base_csr, sll_dev0_tim);
    
/*  set dev 1 rw cmd  */
    IOWR_SLL_XSPI_MC_REG_DEV0_CMD1(base_csr, sll_xspi_type1_data[2]);
    IOWR_SLL_XSPI_MC_REG_DEV0_CMD0(base_csr, sll_xspi_type1_data[3]);

/*  switch from x1 to DDR if needed  */    
    if (bootmode == 1) {
    IOWR_SLL_XSPI_MC_REG_SPI_DDR0(base_csr, sll_xspi_type1_data[5]);
    IOWR_SLL_XSPI_MC_REG_SPI_DDR1(base_csr, sll_xspi_type1_data[4]);  	
 
    //wait 100 us;
     SLL_DelayMicroseconds(100);
    }

/*  program xSPI  WREN  */
    sll_cs0_xspi_p1_format_1a_write(base_csr, 0x0606);

/*  program xSPI - program cas latency on Volatile CFG1 register */
    sll_cs0_xspi_p1_format_1d_write_x16(base_csr, 0x8181, 0x00000001, sll_xspi_type1_cfg1);

}


/******************************************************************
*  Function: xspi_mc_dev0_xspi_type2_init
*
*  Purpose: Set Device 0 parameters for em064lx memory
*
******************************************************************/
 void xspi_mc_dev0_xspi_type2_init(uint32_t base_csr,  uint8_t size_log2, uint8_t read_latency ,  uint8_t bootmode)
{
    uint32_t  sll_dev0_cfg        =  sll_xspi_type2_data[0] | (size_log2    << XSPI_MC_REG_DEV_CFG_DEV_SIZE_IDX);
    uint32_t  sll_dev0_tim        =  sll_xspi_type2_data[1] | (read_latency << XSPI_MC_REG_DEV_TIM_READ_TACC_IDX) ;
    uint32_t  sll_xspi_type2_cfg1 =  read_latency | (read_latency << 8);

/*  set dev 1 config  */
    IOWR_SLL_XSPI_MC_REG_DEV0_CFG(base_csr, sll_dev0_cfg);

/*  set dev 1 timing  */
    IOWR_SLL_XSPI_MC_REG_DEV0_TIM(base_csr, sll_dev0_tim);
    
/*  set dev 1 rw cmd  */
    IOWR_SLL_XSPI_MC_REG_DEV0_CMD1(base_csr, sll_xspi_type2_data[2]);
    IOWR_SLL_XSPI_MC_REG_DEV0_CMD0(base_csr, sll_xspi_type2_data[3]);

/*  switch from x1 to DDR if needed  */    
    if (bootmode == 1) {
    IOWR_SLL_XSPI_MC_REG_SPI_DDR0(base_csr, sll_xspi_type2_data[5]);
    IOWR_SLL_XSPI_MC_REG_SPI_DDR1(base_csr, sll_xspi_type2_data[4]);  	
 
    //wait 100 us;
     SLL_DelayMicroseconds(200);
    }

/*  program xSPI  WREN  */
    sll_cs0_xspi_p1_format_1a_write(base_csr, 0x0606);

/*  program xSPI - program cas latency on Volatile CFG1 register */
    sll_cs0_xspi_p1_format_1d_write_x16(base_csr, 0x8181, 0x00000001, sll_xspi_type2_cfg1);

/*  program xSPI  WREN  */
    sll_cs0_xspi_p1_format_1a_write(base_csr, 0x0606);

/*  program xSPI - 4 Byte Addressing */
    sll_cs0_xspi_p1_format_1d_write_x16(base_csr, 0x8181, 0x00000005, 0xfefe);


}

void xspi_mc_dev0_xspi_type2_04_init(uint32_t base_csr,  uint8_t size_log2, uint8_t read_latency ,  uint8_t bootmode)
{
    uint32_t  sll_dev0_cfg        =  sll_xspi_type2_04_data[0] | (size_log2    << XSPI_MC_REG_DEV_CFG_DEV_SIZE_IDX);
    uint32_t  sll_dev0_tim        =  sll_xspi_type2_04_data[1] | (read_latency << XSPI_MC_REG_DEV_TIM_READ_TACC_IDX) ;
    uint32_t  sll_xspi_type2_cfg1 =  read_latency | (read_latency << 8);

/*  set dev 1 config  */
    IOWR_SLL_XSPI_MC_REG_DEV0_CFG(base_csr, sll_dev0_cfg);

/*  set dev 1 timing  */
    IOWR_SLL_XSPI_MC_REG_DEV0_TIM(base_csr, sll_dev0_tim);
    
/*  set dev 1 rw cmd  */
    IOWR_SLL_XSPI_MC_REG_DEV0_CMD1(base_csr, sll_xspi_type2_04_data[2]);
    IOWR_SLL_XSPI_MC_REG_DEV0_CMD0(base_csr, sll_xspi_type2_04_data[3]);

/*  switch from x1 to DDR if needed  */    
    if (bootmode == 1) {
    IOWR_SLL_XSPI_MC_REG_SPI_DDR0(base_csr, sll_xspi_type2_04_data[5]);
    IOWR_SLL_XSPI_MC_REG_SPI_DDR1(base_csr, sll_xspi_type2_04_data[4]);  	
 
    //wait 100 us;
     SLL_DelayMicroseconds(200);
    }

/*  program xSPI  WREN  */
//    sll_cs0_xspi_p1_format_1a_write(base_csr, 0x0606);

/*  program xSPI - program cas latency on Volatile CFG1 register */
//    sll_cs0_xspi_p1_format_1d_write_x16(base_csr, 0x8181, 0x00000001, sll_xspi_type2_cfg1);

/*  program xSPI  WREN  */
//    sll_cs0_xspi_p1_format_1a_write(base_csr, 0x0606);

/*  program xSPI - 4 Byte Addressing */
//    sll_cs0_xspi_p1_format_1d_write_x16(base_csr, 0x8181, 0x00000005, 0xfefe);


}

/******************************************************************
*  Function: xspi_mc_dev0_mx25lm_init
*
*  Purpose: Set Device 1 parameters for macronix mx25 memory
*
******************************************************************/
 void xspi_mc_dev0_mx25lm_init(uint32_t base_csr,  uint8_t size_log2, uint8_t read_latency ,  uint8_t bootmode)
{
    uint32_t  sll_dev0_cfg        =  sll_mx25lm_data[0] | (size_log2    << XSPI_MC_REG_DEV_CFG_DEV_SIZE_IDX);
    uint32_t  sll_dev0_tim        =  sll_mx25lm_data[1] | (read_latency << XSPI_MC_REG_DEV_TIM_READ_TACC_IDX) ;
    uint32_t  sll_xspi_type1_cfg1 =  sll_mx25lm_data[6];

/*  set dev 1 config  */
    IOWR_SLL_XSPI_MC_REG_DEV0_CFG(base_csr, sll_dev0_cfg);

/*  set dev 1 timing  */
    IOWR_SLL_XSPI_MC_REG_DEV0_TIM(base_csr, sll_dev0_tim);
    
/*  set dev 1 rw cmd  */
    IOWR_SLL_XSPI_MC_REG_DEV0_CMD1(base_csr, sll_mx25lm_data[2]);
    IOWR_SLL_XSPI_MC_REG_DEV0_CMD0(base_csr, sll_mx25lm_data[3]);

/*  switch from x1 to DDR if needed  */    
    if (bootmode == 1) {
    IOWR_SLL_XSPI_MC_REG_SPI_DDR0(base_csr, sll_mx25lm_data[5]);
    IOWR_SLL_XSPI_MC_REG_SPI_DDR1(base_csr, sll_mx25lm_data[4]);  	
 
    //wait 100 us;
     SLL_DelayMicroseconds(100);
    }

/*  program xSPI  WREN  */
    sll_cs0_xspi_p1_format_1a_write(base_csr, 0x06F9);

/*  program xSPI - program cas latency on Volatile CFG1 register */
    sll_cs0_xspi_p1_format_1d_write_x16(base_csr, 0x728D, 0x00000300, sll_xspi_type1_cfg1);

}

/******************************************************************
*  Function: xspi_mc_dev0_mx25um_init
*
*  Purpose: Set Device 1 parameters for macronix mx25 memory
*
******************************************************************/
 void xspi_mc_dev0_mx25um_init(uint32_t base_csr,  uint8_t size_log2, uint8_t read_latency ,  uint8_t bootmode)
{
    uint32_t  sll_dev0_cfg        =  sll_mx25um_data[0] | (size_log2    << XSPI_MC_REG_DEV_CFG_DEV_SIZE_IDX);
    uint32_t  sll_dev0_tim        =  sll_mx25um_data[1] | (read_latency << XSPI_MC_REG_DEV_TIM_READ_TACC_IDX) ;
    uint32_t  sll_xspi_type1_cfg1 =  sll_mx25um_data[6];

/*  set dev 1 config  */
    IOWR_SLL_XSPI_MC_REG_DEV0_CFG(base_csr, sll_dev0_cfg);

/*  set dev 1 timing  */
    IOWR_SLL_XSPI_MC_REG_DEV0_TIM(base_csr, sll_dev0_tim);
    
/*  set dev 1 rw cmd  */
    IOWR_SLL_XSPI_MC_REG_DEV0_CMD1(base_csr, sll_mx25um_data[2]);
    IOWR_SLL_XSPI_MC_REG_DEV0_CMD0(base_csr, sll_mx25um_data[3]);

/*  switch from x1 to DDR if needed  */    
    if (bootmode == 1) {
    IOWR_SLL_XSPI_MC_REG_SPI_DDR0(base_csr, sll_mx25um_data[5]);
    IOWR_SLL_XSPI_MC_REG_SPI_DDR1(base_csr, sll_mx25um_data[4]);  	
 
    //wait 100 us;
     SLL_DelayMicroseconds(100);
    }

/*  program xSPI  WREN  */
    sll_cs0_xspi_p1_format_1a_write(base_csr, 0x06F9);

/*  program xSPI - program cas latency on Volatile CFG1 register */
    sll_cs0_xspi_p1_format_1d_write_x16(base_csr, 0x728D, 0x00000300, sll_xspi_type1_cfg1);

}




/******************************************************************
*  Function: xspi_mc_dev1_null_init
*
*  Purpose: Set Device 1 parameters for No memory
*
******************************************************************/
 void xspi_mc_dev1_null_init(uint32_t base_csr)
{

/*  set dev 1 config  */
    IOWR_SLL_XSPI_MC_REG_DEV1_CFG(base_csr, 0x00000000);

/*  set dev 1 timing  */
    IOWR_SLL_XSPI_MC_REG_DEV1_TIM(base_csr, 0x00000000);
}


/******************************************************************
*  Function: xspi_mc_dev1_s27ks0641_init
*
*  Purpose: Set Device 1 parameters for s27ks0641 memory
*
******************************************************************/
 void xspi_mc_dev1_s27ks_01_init(uint32_t base_csr,  uint8_t size_log2  )
{
    uint32_t  sll_dev1_cfg =  sll_s27ks_01_data[0] | (size_log2    << XSPI_MC_REG_DEV_CFG_DEV_SIZE_IDX);
   
/*  set dev 1 config  */
    IOWR_SLL_XSPI_MC_REG_DEV1_CFG(base_csr,  sll_dev1_cfg);

/*  set dev 1 timing  */
    IOWR_SLL_XSPI_MC_REG_DEV1_TIM(base_csr,  sll_s27ks_01_data[1]);

/*  set dev 1 rw cmd  */
    IOWR_SLL_XSPI_MC_REG_DEV1_CMD1(base_csr, sll_s27ks_01_data[2]);
    IOWR_SLL_XSPI_MC_REG_DEV1_CMD0(base_csr, sll_s27ks_01_data[3]);

}


/******************************************************************
*  Function: xspi_mc_dev1_s27ks0642_init
*
*  Purpose: Set Device 1 parameters for s27ks0642 memory
*
******************************************************************/
 void xspi_mc_dev1_s27ks_02_init(uint32_t base_csr,  uint8_t size_log2  )
{
    uint32_t  sll_dev1_cfg =  sll_s27ks_02_data[0] | (size_log2    << XSPI_MC_REG_DEV_CFG_DEV_SIZE_IDX);
   
/*  set dev 1 config  */
    IOWR_SLL_XSPI_MC_REG_DEV1_CFG(base_csr,  sll_dev1_cfg);

/*  set dev 1 timing  */
    IOWR_SLL_XSPI_MC_REG_DEV1_TIM(base_csr,  sll_s27ks_02_data[1]);

/*  set dev 1 rw cmd  */
    IOWR_SLL_XSPI_MC_REG_DEV1_CMD1(base_csr, sll_s27ks_02_data[2]);
    IOWR_SLL_XSPI_MC_REG_DEV1_CMD0(base_csr, sll_s27ks_02_data[3]);

}


/******************************************************************
*  Function: xspi_mc_dev1_s27ks0643_init
*
*  Purpose: Set Device 1 parameters for s27ks0643 memory
*
******************************************************************/
 void xspi_mc_dev1_s27ks_03_init(uint32_t base_csr,  uint8_t size_log2  )
{
    uint32_t  sll_dev1_cfg =  sll_s27ks_03_data[0] | (size_log2    << XSPI_MC_REG_DEV_CFG_DEV_SIZE_IDX);
   
/*  set dev 1 config  */
    IOWR_SLL_XSPI_MC_REG_DEV1_CFG(base_csr,  sll_dev1_cfg);

/*  set dev 1 timing  */
    IOWR_SLL_XSPI_MC_REG_DEV1_TIM(base_csr,  sll_s27ks_03_data[1]);

/*  set dev 1 rw cmd  */
    IOWR_SLL_XSPI_MC_REG_DEV1_CMD1(base_csr, sll_s27ks_03_data[2]);
    IOWR_SLL_XSPI_MC_REG_DEV1_CMD0(base_csr, sll_s27ks_03_data[3]);

/*  program xSPI  WREN  */
    sll_cs1_xspi_p1_format_1a_write(base_csr, 0x0606);

}

/******************************************************************
*  Function: xspi_mc_dev1_jsc64ssp8ag_init
*
*  Purpose: Set Device 1 parameters for jsc64ssp8ag memory
*
******************************************************************/
 void xspi_mc_dev1_jsc_ssp8ag_init(uint32_t base_csr,  uint8_t size_log2)
{
    uint32_t  sll_dev1_cfg =  sll_jsc_ssp8ag_data[0] | (size_log2    << XSPI_MC_REG_DEV_CFG_DEV_SIZE_IDX);
   
/*  set dev 1 config  */
    IOWR_SLL_XSPI_MC_REG_DEV1_CFG(base_csr,  sll_dev1_cfg);

/*  set dev 1 timing  */
    IOWR_SLL_XSPI_MC_REG_DEV1_TIM(base_csr,  sll_jsc_ssp8ag_data[1]);

/*  set dev 1 rw cmd  */
    IOWR_SLL_XSPI_MC_REG_DEV1_CMD1(base_csr, sll_jsc_ssp8ag_data[2]);
    IOWR_SLL_XSPI_MC_REG_DEV1_CMD0(base_csr, sll_jsc_ssp8ag_data[3]);

/*  program OctaRAM CR0  */
    sll_xspi_mc_reg_write (base_csr, 0x00006000, 0x00040000, SLL_XSPI_MC_RAM_CS1_WR,  sll_jsc_ssp8ag_data[4]);

}

/******************************************************************
*  Function: xspi_mc_dev1_issi_wvo_init
*
*  Purpose: Set Device 1 parameters for issi_wvo memory
*
******************************************************************/
 void xspi_mc_dev1_issi_wvo_init(uint32_t base_csr,  uint8_t size_log2)
{
    uint32_t  sll_dev1_cfg =  sll_issi_wvo_data[0] | (size_log2    << XSPI_MC_REG_DEV_CFG_DEV_SIZE_IDX);
   
/*  set dev 1 config  */
    IOWR_SLL_XSPI_MC_REG_DEV1_CFG(base_csr,  sll_dev1_cfg);

/*  set dev 1 timing  */
    IOWR_SLL_XSPI_MC_REG_DEV1_TIM(base_csr,  sll_issi_wvo_data[1]);

/*  set dev 1 rw cmd  */
    IOWR_SLL_XSPI_MC_REG_DEV1_CMD1(base_csr, sll_issi_wvo_data[2]);
    IOWR_SLL_XSPI_MC_REG_DEV1_CMD0(base_csr, sll_issi_wvo_data[3]);

/*  program OctaRAM CR0  */
    sll_xspi_mc_reg_write (base_csr, 0x00006000, 0x00040000, SLL_XSPI_MC_RAM_CS1_WR,  sll_issi_wvo_data[4]);

}

/******************************************************************
*  Function: xspi_mc_dev1_ap6408l_ob_init
*
*  Purpose: Set Device 1 parameters for ap6408l_ob memory
*
******************************************************************/
 void xspi_mc_dev1_aps_08l_ob_init(uint32_t base_csr,  uint8_t size_log2  )
{
    uint32_t  sll_dev1_cfg =  sll_aps_08l_ob_data[0] | (size_log2    << XSPI_MC_REG_DEV_CFG_DEV_SIZE_IDX);
   
/*  set dev 1 config  */
    IOWR_SLL_XSPI_MC_REG_DEV1_CFG(base_csr,  sll_dev1_cfg);

/*  set dev 1 timing  */
    IOWR_SLL_XSPI_MC_REG_DEV1_TIM(base_csr, sll_aps_08l_ob_data[1]);

/*  set dev 1 rw cmd  */
    IOWR_SLL_XSPI_MC_REG_DEV1_CMD1(base_csr, sll_aps_08l_ob_data[2]);
    IOWR_SLL_XSPI_MC_REG_DEV1_CMD0(base_csr, sll_aps_08l_ob_data[3]);

/*  program xcella RAM - CR0, CR4, CR8  */
    sll_xspi_mc_reg_write (base_csr, 0x0000C0C0, 0x00000000, SLL_XSPI_MC_RAM_CS1_WR,  sll_aps_08l_ob_data[4]);
    sll_xspi_mc_reg_write (base_csr, 0x0000C0C0, 0x00000004, SLL_XSPI_MC_RAM_CS1_WR,  sll_aps_08l_ob_data[5]);
    sll_xspi_mc_reg_write (base_csr, 0x0000C0C0, 0x00000008, SLL_XSPI_MC_RAM_CS1_WR,  sll_aps_08l_ob_data[6]);
}




/******************************************************************
*  Function: xspi_mc_cntrl_dev0_init
*
*  Purpose: Init Memory Controller 
*
******************************************************************/
uint32_t xspi_mc_cntrl_dev0_init(uint32_t base_csr, uint32_t base_addr, uint32_t dev_name)
{
  uint8_t dev_type               = MEM_NO_DEVICE;
  uint8_t dev_size_log2          = 0x0;
  uint8_t dev_read_latency       = 0x10;
  uint8_t dev_boot_mode          = 0;  
  uint32_t mem_size_in_mbit      = 0;
   
  //get device parameters from model name
  dev_type               = (dev_name >> DEVICE_NAME_MEM_TYPE_IDX ) & 0xFF;
  dev_size_log2          = (dev_name >> DEVICE_NAME_MEM_SIZE_IDX ) & 0xFF;
  dev_read_latency       = (dev_name >> DEVICE_NAME_READ_TACC_IDX) & 0xFF;
  dev_boot_mode          = (dev_name >> DEVICE_NAME_BOOT_MODE_IDX) & 0xFF;
  
  //calculate memory size in megabit
  mem_size_in_mbit       = 1 << dev_size_log2 ;

/*  set base address  */
  IOWR_SLL_XSPI_MC_REG_DEV0_MBA0(base_csr, base_addr);
  IOWR_SLL_XSPI_MC_REG_DEV0_MBA1(base_csr, 0x00000000);


  /*Set Device 0 parameters */
  switch (dev_type)
  {
      case MEM_HYPERFLASH_1_0 : //s26ks512s
     	xspi_mc_dev0_s26ks_init(base_csr, dev_size_log2);
      break;

      case MEM_SEMPERFLASH_1_0 : //s26hs512s
     	xspi_mc_dev0_s26hs_init(base_csr, dev_size_log2, dev_boot_mode);
      break;

      case MEM_SEMPERXSPI_1_0 : //s28hs512s
     	xspi_mc_dev0_s28hs_init(base_csr, dev_size_log2, dev_boot_mode);
      break;

      case MEM_XSPIFLASH_1_0 : //mt35xu512
     	xspi_mc_dev0_xspi_type1_init(base_csr, dev_size_log2, dev_read_latency, dev_boot_mode);
      break;

      case MEM_XSPIFLASH_1_1 : //em064lx
     	xspi_mc_dev0_xspi_type2_init(base_csr, dev_size_log2, dev_read_latency, dev_boot_mode);
      break;

      case MEM_XSPIFLASH_1_2 : //em064lx_04
     	xspi_mc_dev0_xspi_type2_04_init(base_csr, dev_size_log2, dev_read_latency, dev_boot_mode);
      break;

      case MEM_OCTAFLASH_1_0 : //mx25lm
     	xspi_mc_dev0_mx25lm_init(base_csr, dev_size_log2, dev_read_latency, dev_boot_mode);
      break;

      case MEM_OCTAFLASH_1_1 : //mx25um
     	xspi_mc_dev0_mx25um_init(base_csr, dev_size_log2, dev_read_latency, dev_boot_mode);
      break;
   
      default : {
  	  /*  set base address  */
 	  IOWR_SLL_XSPI_MC_REG_DEV0_MBA0(base_csr, 0x00000000);
      IOWR_SLL_XSPI_MC_REG_DEV0_MBA1(base_csr, 0x00000000);
      xspi_mc_dev0_null_init(base_csr); 
      mem_size_in_mbit = 0;
      }
      
  }
         
  return  (mem_size_in_mbit * 1024 * 1024) / 8;

}



/******************************************************************
*  Function: xspi_mc_cntrl_dev1_init
*
*  Purpose: Init Memory Controller 
*
******************************************************************/
uint32_t xspi_mc_cntrl_dev1_init(uint32_t base_csr, uint32_t base_addr, uint32_t dev_name)
{
  uint8_t dev_type          = MEM_NO_DEVICE;
  uint8_t dev_size_log2     = 0x0;
  uint32_t mem_size_in_mbit = 0;
   
  //get device parameters from model name
  dev_type               = (dev_name >> DEVICE_NAME_MEM_TYPE_IDX ) & 0xFF;
  dev_size_log2          = (dev_name >> DEVICE_NAME_MEM_SIZE_IDX ) & 0xFF;
  
  //calculate memory size in megabit
  mem_size_in_mbit          = 1 << dev_size_log2 ;

/*  set base address  */
  IOWR_SLL_XSPI_MC_REG_DEV1_MBA0(base_csr, base_addr);
  IOWR_SLL_XSPI_MC_REG_DEV1_MBA1(base_csr, 0x00000000);


  /*Set Device 1 parameters */
  switch (dev_type)
  {
      case MEM_HYPERRAM_1_0: //s27ks0641
      	xspi_mc_dev1_s27ks_01_init(base_csr, dev_size_log2);
        break;

      case MEM_HYPERRAM_2_0: //s27ks0642
      	xspi_mc_dev1_s27ks_02_init(base_csr, dev_size_log2);
        break;

     case MEM_XSPIRAM_2_0: //s27ks0643
      	xspi_mc_dev1_s27ks_03_init(base_csr, dev_size_log2);
        break;
  
      case MEM_OCTARAM_2_0: //jsc64ssp8ag
      	xspi_mc_dev1_jsc_ssp8ag_init(base_csr, dev_size_log2);
        break;

      case MEM_OCTARAM_2_1: //ISSI octaram
      	xspi_mc_dev1_issi_wvo_init(base_csr, dev_size_log2);
        break;

      case MEM_XCCELARAM_2_0: //ap6408l_ob
      	xspi_mc_dev1_aps_08l_ob_init(base_csr, dev_size_log2);
        break;


      default :
      xspi_mc_dev1_null_init(base_csr); 
      mem_size_in_mbit = 0;
      
  }
        
       
  return  (mem_size_in_mbit * 1024 * 1024) / 8;

}

/******************************************************************
*  Function: xspi_mc_cntrl_init
*
*  Purpose: Init Memory Controller 
*
******************************************************************/

uint32_t xspi_mc_cntrl_init(xSPI_MBMC_Info *g_xSPI_MBMC_inst)
{

  uint32_t base_csr               = g_xSPI_MBMC_inst->csr_base;
  uint32_t dev0_name              = g_xSPI_MBMC_inst->dev0_name;
  uint32_t dev1_name              = g_xSPI_MBMC_inst->dev1_name;

  volatile uint32_t return_rdata  = 0;
  uint32_t xspi_mc_dev0_mem_size  = 0;
  uint32_t xspi_mc_dev1_mem_size  = 0;
  uint32_t xspi_mc_dev0_address   = g_xSPI_MBMC_inst->dev0_mem_base;
  uint32_t xspi_mc_dev1_address   = g_xSPI_MBMC_inst->dev0_mem_base;

  /* READ ID */
  return_rdata = IORD_SLL_XSPI_MC_REG_ID0(base_csr);
  lld_printf("xSPI-MC ID0 is 0x%x \r\n ", return_rdata);

  return_rdata = IORD_SLL_XSPI_MC_REG_ID1(base_csr);
  lld_printf("xSPI-MC ID1 is 0x%x \r\n", return_rdata);

  /* SET MODE Control to xSPI */
  IOWR_SLL_XSPI_MC_MODE_HXSPI(base_csr);
  
  /* Clear Device Reset */
  IOWR_SLL_XSPI_MC_DEV_RST_CLR(base_csr);

  
  /* Wait 300 us */
  SLL_DelayMicroseconds (500);

  /* Wait power UP ready */
  sll_xspi_mc_wait_pwrup_rdy(base_csr);

  /*Set Device 0 parameters */
  xspi_mc_dev0_mem_size = xspi_mc_cntrl_dev0_init(base_csr, xspi_mc_dev0_address, dev0_name);

  //update address, mem size on device 0
  g_xSPI_MBMC_inst->dev0_mem_size = xspi_mc_dev0_mem_size;

  /*Set Device 1 base address based on size of Device 0 memory */
  xspi_mc_dev1_address += xspi_mc_dev0_mem_size;   

  /*Set Device 1 parameters */
  xspi_mc_dev1_mem_size = xspi_mc_cntrl_dev1_init(base_csr, xspi_mc_dev1_address, dev1_name);

  //update address, mem size on device 1
  g_xSPI_MBMC_inst->dev1_mem_base = xspi_mc_dev1_address;
  g_xSPI_MBMC_inst->dev1_mem_size = xspi_mc_dev1_mem_size;
  
  /*Set Controller ready  */
  IOWR_SLL_XSPI_MC_DEV_SETUP_RDY(base_csr);
  
  return xspi_mc_dev1_mem_size;

}



